package chess4j.utils;

import java.util.List;

import chess4j.App;
import chess4j.board.Board;
import chess4j.moves.Move;

public class GameStatusChecker {
	
	public static GameStatus getGameStatus(Board b) {
		List<Move> moves = App.getMoveGen().genLegalMoves(b);
		if (moves.size()==0) {
			if (b.isPlayerInCheck()) {
				return GameStatus.CHECKMATED;
			} else {
				return GameStatus.STALEMATED;
			}
		}
		
		return GameStatus.INPROGRESS;
	}
}
